attribute vec2 coord_xz;
attribute float coord_y;

attribute float factor_alpha;
varying float f_factor_alpha;

#ifdef MULTI_TEX
attribute float factor_foam;
varying float f_factor_foam;
varying vec2 f_texcoord_foam;
#endif

varying vec4 f_colorLight;

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
uniform mat4 v;
#endif

uniform mat4 mvp, m;
uniform mat4 v_inv;


void main(void)
{
	vec4 coord = vec4(coord_xz.x, coord_y, coord_xz.y, 1.0);
	//Position
	gl_Position = mvp * coord;
	vec4 positionWorld = m * coord;

	//Towards Fragment Shader
	f_factor_alpha = factor_alpha;

	//Lighting
	vec3 normalDirection = vec3(0.0, 1.0, 0.0);
	vec3 lightDirection = getLightDirection(currentLight.position);
	vec3 viewDirection = getViewDirection(v_inv, positionWorld);

	vec3 ambientLighting = getAmbientLighting(currentLight.ambient, currentMaterial.ambient);

	vec3 materialSpecular = currentMaterial.specular;
	if(positionWorld.z > EXT_AREA_START)
		materialSpecular *= 1.0-(positionWorld.z-EXT_AREA_START)/EXT_AREA_WIDTH;
	vec3 specularReflection = getSpecularReflection(currentLight.specular, materialSpecular, currentMaterial.shininess,
													 normalDirection, lightDirection, viewDirection);

	//Final light (towards Fragment Shader)
	f_colorLight = vec4(ambientLighting + specularReflection, 1.0);

#ifdef MULTI_TEX
	f_factor_foam = factor_foam;
	f_texcoord_foam = vec2(coord.x, coord.z)*TEX_COORD_SCALE*WATER_FOAM_SCALE;
#endif

#ifdef FOG
	f_fogFactor = getFogFactor(v, positionWorld);
	f_fogFactorGround = getFogFactorGround(f_fogFactor, positionWorld);
#endif
}
